#include <bits/stdc++.h>

using namespace std;

const int MAX = 300005;

const int md = 1e9 + 7;

int ckadd(int a, int b) {
  return a + b >= md ? a + b - md : a + b;
}

int cksub(int a, int b) {
  return a >= b ? a - b : a - b + md;
}

int ckmul(int a, int b) {
  return a * 1LL * b % md;
}

int st[8 * MAX];

void modify(int id, int l, int r, int ll, int rr, int v) {
  if (ll <= l && r <= rr) {
    st[id] = ckadd(st[id], v);
    return;
  }
  int mid = (l + r) >> 1;
  if (rr <= mid) {
    modify(id * 2, l, mid, ll, rr, v);
  } else if (ll > mid) {
    modify(id * 2 + 1, mid + 1, r, ll, rr, v);
  } else {
    modify(id * 2, l, mid, ll, rr, v);
    modify(id * 2 + 1, mid + 1, r, ll, rr, v);
  }
}

int query(int id, int l, int r, int i) {
  if (l == r) {
    return st[id];
  }
  int mid = (l + r) >> 1;
  if (i <= mid) {
    return ckadd(st[id], query(id * 2, l, mid, i));
  } else {
    return ckadd(st[id], query(id * 2 + 1, mid + 1, r, i));
  }
}

void Penjanje(int N,int Q,int *P,int *F,int *U,int *O) {
  int mx = 0;
  for (int i = 1; i <= N; i++) {
    mx = max(mx, i - F[i]);
  }
  vector<int> order;
  for (int i = 1; i <= Q; i++) {
    order.push_back(i);
  }
  sort(order.begin(), order.end(), [&](int i, int j) {
    return U[i] > U[j];
  });
  vector<int> dp(N + 1);
  for (int i = 1; i <= N; i++) {
    dp[i] = P[i];
  }
  vector<int> coeff(N + 1);
  int sum = 0;
  int ptr = 0;
  for (int i = N; i >= 1; i--) {
    int val = ckadd(query(1, 1, N, i), 1);
    sum = ckadd(sum, ckmul(dp[i], val));
    if (F[i] < i) {
      modify(1, 1, N, F[i], i - 1, ckmul(val, P[i] - 1));
    }
    while (ptr < (int) order.size() && U[order[ptr]] == i) {
      O[order[ptr]] = sum;
      ptr += 1;
    }
  }
}

/*
6 2
4 2 1 2 1 4
1 2 1 3 2 5
1 4
*/